/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.util.Log;
import java.util.ArrayList;
import net.posprinter.utils.DataForSendToPrinterPos80;

public class BitmapToByteData {
    public static byte[] rasterBmpToSendData(int m, Bitmap mBitmap, BmpType bmpType, AlignType alignType, int pagewidth) {
        Bitmap bitmap = BitmapToByteData.toGrayscale(mBitmap);
        switch (bmpType.ordinal()) {
            case 0: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case 1: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width > 1016) {
            width = 1016;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height);
        }
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] data = BitmapToByteData.getbmpdata(pixels, width, height);
        int n = (width + 7) / 8;
        byte xL = (byte)(n % 256);
        byte xH = (byte)(n / 256);
        int x = (height + 23) / 24;
        ArrayList<Byte> list = new ArrayList<Byte>();
        byte[] head = new byte[]{29, 118, 48, (byte)m, xL, xH, 24, 0};
        int mL = 0;
        int mH = 0;
        if (width >= pagewidth) {
            alignType = AlignType.Left;
        }
        switch (alignType.ordinal()) {
            case 1: {
                mL = 0;
                mH = 0;
                break;
            }
            case 2: {
                mL = (pagewidth - width) / 2 % 256;
                mH = (pagewidth - width) / 2 / 256;
                break;
            }
            case 3: {
                mL = (pagewidth - width) % 256;
                mH = (pagewidth - width) / 256;
            }
        }
        byte[] aligndata = DataForSendToPrinterPos80.setAbsolutePrintPosition(mL, mH);
        for (int i = 0; i < x; ++i) {
            byte b;
            int var22;
            int var23;
            byte[] var24;
            byte[] newdata;
            if (i == x - 1) {
                if (height % 24 == 0) {
                    head[6] = 24;
                    newdata = new byte[n * 24];
                    System.arraycopy(data, 24 * i * n, newdata, 0, 24 * n);
                } else {
                    head[6] = (byte)(height % 24);
                    newdata = new byte[height % 24 * n];
                    System.arraycopy(data, 24 * i * n, newdata, 0, height % 24 * n);
                }
            } else {
                newdata = new byte[n * 24];
                System.arraycopy(data, 24 * i * n, newdata, 0, 24 * n);
            }
            if (alignType != AlignType.Left) {
                var24 = aligndata;
                var23 = aligndata.length;
                for (var22 = 0; var22 < var23; ++var22) {
                    b = var24[var22];
                    list.add(b);
                }
            }
            var24 = head;
            var23 = head.length;
            for (var22 = 0; var22 < var23; ++var22) {
                b = var24[var22];
                list.add(b);
            }
            var24 = newdata;
            var23 = newdata.length;
            for (var22 = 0; var22 < var23; ++var22) {
                b = var24[var22];
                list.add(b);
            }
        }
        byte[] byteData = new byte[list.size()];
        for (int i = 0; i < byteData.length; ++i) {
            byteData[i] = (Byte)list.get(i);
        }
        return byteData;
    }

    public static byte[] rasterBmpToSendData(int m, Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.toGrayscale(mBitmap);
        switch (bmpType.ordinal()) {
            case 1: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case 2: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width > 1016) {
            width = 1016;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height);
        }
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] data = BitmapToByteData.getbmpdata(pixels, width, height);
        int n = (width + 7) / 8;
        byte xL = (byte)(n % 256);
        byte xH = (byte)(n / 256);
        int x = (height + 23) / 24;
        ArrayList<Byte> list = new ArrayList<Byte>();
        byte[] head = new byte[]{29, 118, 48, (byte)m, xL, xH, 24, 0};
        for (int i = 0; i < x; ++i) {
            byte b;
            int var17;
            byte[] newdata;
            if (i == x - 1) {
                if (height % 24 == 0) {
                    head[6] = 24;
                    newdata = new byte[n * 24];
                    System.arraycopy(data, 24 * i * n, newdata, 0, 24 * n);
                } else {
                    head[6] = (byte)(height % 24);
                    newdata = new byte[height % 24 * n];
                    System.arraycopy(data, 24 * i * n, newdata, 0, height % 24 * n);
                }
            } else {
                newdata = new byte[n * 24];
                System.arraycopy(data, 24 * i * n, newdata, 0, 24 * n);
            }
            byte[] var19 = head;
            int var18 = head.length;
            for (var17 = 0; var17 < var18; ++var17) {
                b = var19[var17];
                list.add(b);
            }
            var19 = newdata;
            var18 = newdata.length;
            for (var17 = 0; var17 < var18; ++var17) {
                b = var19[var17];
                list.add(b);
            }
        }
        byte[] byteData = new byte[list.size()];
        for (int i = 0; i < byteData.length; ++i) {
            byteData[i] = (Byte)list.get(i);
        }
        return byteData;
    }

    public static byte[] flashBmpToSendData(Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.convertBmp(mBitmap);
        bitmap = BitmapToByteData.toGrayscale(bitmap);
        switch (bmpType.ordinal()) {
            case 1: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case 2: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int n = (width + 7) / 8;
        int h = (height + 7) / 8;
        if (n <= 1023 && h <= 288 && n != 0 && h != 0) {
            if (n * h >= 1023) {
                return new byte[0];
            }
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            byte[] data = BitmapToByteData.getbmpdata(pixels, width, height);
            byte xL = (byte)(n % 256);
            byte xH = (byte)(n / 256);
            byte yL = (byte)(h % 256);
            byte yH = (byte)(h / 256);
            byte[] head = new byte[]{xL, xH, yL, yH};
            data = BitmapToByteData.byteMerger(head, data);
            return data;
        }
        return new byte[0];
    }

    public static byte[] downLoadBmpToSendTSCdownloadcommand(Bitmap mBitmap) {
        int width = mBitmap.getWidth();
        int height = mBitmap.getHeight();
        int[] pixels = new int[width * height];
        mBitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] send = new byte[width * height];
        for (int i = 0; i < pixels.length; ++i) {
            send[i] = (byte)pixels[i];
        }
        byte[] data = BitmapToByteData.getbmpdataTsc(pixels, width, height);
        return data;
    }

    public static byte[] downLoadBmpToSendTSCData(Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.toGrayscale(mBitmap);
        switch (bmpType.ordinal()) {
            case 1: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case 2: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int n = (width + 7) / 8;
        int h = (height + 7) / 8;
        if (n <= 255 && h <= 48 && n != 0 && h != 0) {
            if (n * h > 912) {
                return new byte[0];
            }
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            byte[] data = BitmapToByteData.getbmpdataTsc(pixels, width, height);
            return data;
        }
        return new byte[0];
    }

    public static byte[] downLoadBmpToSendData(Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.convertBmp(mBitmap);
        bitmap = BitmapToByteData.toGrayscale(bitmap);
        switch (bmpType.ordinal()) {
            case 1: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case 2: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int n = (width + 7) / 8;
        int h = (height + 7) / 8;
        if (n <= 255 && h <= 48 && n != 0 && h != 0) {
            if (n * h > 912) {
                return new byte[0];
            }
            int[] pixels = new int[width * height];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            byte[] data = BitmapToByteData.getbmpdata(pixels, width, height);
            byte[] head = new byte[]{(byte)n, (byte)h};
            data = BitmapToByteData.byteMerger(head, data);
            return data;
        }
        return new byte[0];
    }

    private static Bitmap toGrayscale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }

    private static Bitmap convertGreyImg(Bitmap img) {
        int grey;
        int j;
        int i;
        int m;
        int width = img.getWidth();
        int height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        double redSum = 0.0;
        double total = width * height;
        for (m = 0; m < height; ++m) {
            for (i = 0; i < width; ++i) {
                j = pixels[width * m + i];
                grey = (j & 0xFF0000) >> 16;
                redSum += (double)grey;
            }
        }
        m = (int)(redSum / total);
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                grey = pixels[width * i + j];
                int alpha1 = -16777216;
                int red = (grey & 0xFF0000) >> 16;
                int green = (grey & 0xFF00) >> 8;
                int blue = grey & 0xFF;
                if (red >= m) {
                    blue = 255;
                    green = 255;
                    red = 255;
                } else {
                    blue = 0;
                    green = 0;
                    red = 0;
                }
                pixels[width * i + j] = grey = alpha1 | red << 16 | green << 8 | blue;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    private static Bitmap convertGreyImgByFloyd(Bitmap img) {
        int g;
        int j;
        int i;
        int e;
        int width = img.getWidth();
        int height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        for (e = 0; e < height; ++e) {
            for (i = 0; i < width; ++i) {
                j = pixels[width * e + i];
                gray[width * e + i] = g = (j & 0xFF0000) >> 16;
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                g = gray[width * i + j];
                if (g >= 128) {
                    pixels[width * i + j] = -1;
                    e = g - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    e = g - 0;
                }
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    gray[n] = gray[n] + 3 * e / 8;
                    int n2 = width * (i + 1) + j;
                    gray[n2] = gray[n2] + 3 * e / 8;
                    int n3 = width * (i + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 4;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    gray[n] = gray[n] + 3 * e / 8;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                gray[n] = gray[n] + e / 4;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    private static byte[] bagetbmpdata(int[] b, int w, int m) {
        int x;
        int nH = w / 256;
        int nL = w % 256;
        byte[] head = new byte[]{27, 42, (byte)m, (byte)nL, (byte)nH};
        byte[] end = new byte[]{27, 74, 16};
        int mask = 1;
        byte[] perdata = new byte[w];
        for (x = 0; x < w; ++x) {
            for (int y = 0; y < 8; ++y) {
                if ((b[y * w + x] & 0xFF0000) >> 16 == 0) continue;
                int n = x;
                perdata[n] = (byte)(perdata[n] | (byte)(mask << 7 - y));
            }
        }
        for (x = 0; x < perdata.length; ++x) {
            perdata[x] = ~perdata[x];
        }
        byte[] data = BitmapToByteData.byteMerger(head, perdata);
        data = BitmapToByteData.byteMerger(data, end);
        return data;
    }

    public static byte[] baBmpToSendData(int m, Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.toGrayscale(mBitmap);
        switch (bmpType.ordinal()) {
            case 1: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case 2: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width > 1016) {
            width = 1016;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height);
        }
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int n = (height + 7) / 8;
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int i = 0; i < n; ++i) {
            byte[] data;
            int[] perPix = new int[width * 8];
            for (int j = 0; j < perPix.length; ++j) {
                perPix[j] = j + 8 * i * width < pixels.length - 1 ? pixels[j + 8 * i * width] : -1;
            }
            byte[] var15 = data = BitmapToByteData.bagetbmpdata(perPix, width, m);
            int var14 = data.length;
            for (int var13 = 0; var13 < var14; ++var13) {
                byte b = var15[var13];
                list.add(b);
            }
        }
        byte[] newdata = new byte[list.size()];
        for (int i = 0; i < newdata.length; ++i) {
            newdata[i] = (Byte)list.get(i);
        }
        return newdata;
    }

    private static byte[] getbmpdata(int[] b, int w, int h) {
        int y;
        int n = (w + 7) / 8;
        byte[] data = new byte[n * h];
        int mask = 1;
        for (y = 0; y < h; ++y) {
            for (int x = 0; x < n * 8; ++x) {
                if (x < w) {
                    if ((b[y * w + x] & 0xFF0000) >> 16 == 0) continue;
                    int n2 = y * n + x / 8;
                    data[n2] = (byte)(data[n2] | (byte)(mask << 7 - x % 8));
                    continue;
                }
                if (x < w) continue;
                int n3 = y * n + x / 8;
                data[n3] = (byte)(data[n3] | (byte)(mask << 7 - x % 8));
            }
        }
        for (y = 0; y < data.length; ++y) {
            data[y] = ~data[y];
        }
        return data;
    }

    private static byte[] getbmpdataTsc(int[] b, int w, int h) {
        int n = (w + 7) / 8;
        byte[] data = new byte[n * h];
        int mask = 1;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < n * 8; ++x) {
                if (x < w) {
                    if ((b[y * w + x] & 0xFF0000) >> 16 == 0) continue;
                    int n2 = y * n + x / 8;
                    data[n2] = (byte)(data[n2] | (byte)(mask << 7 - x % 8));
                    continue;
                }
                if (x < w) continue;
                int n3 = y * n + x / 8;
                data[n3] = (byte)(data[n3] | (byte)(mask << 7 - x % 8));
            }
        }
        return data;
    }

    private static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    private static Bitmap convertBmp(Bitmap bmp) {
        int w = bmp.getWidth();
        int h = bmp.getHeight();
        Bitmap convertBmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(convertBmp);
        Matrix matrix = new Matrix();
        matrix.postScale(-1.0f, 1.0f);
        matrix.postRotate(-90.0f);
        Bitmap newBmp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
        cv.drawBitmap(newBmp, new Rect(0, 0, newBmp.getWidth(), newBmp.getHeight()), new Rect(0, 0, w, h), (Paint)null);
        return convertBmp;
    }

    public static int grayPixle(int pixel) {
        int red = (pixel & 0xFF0000) >> 16;
        int green = (pixel & 0xFF00) >> 8;
        int blue = pixel & 0xFF;
        return (int)((float)red * 0.3f + (float)green * 0.59f + (float)blue * 0.11f);
    }

    public static Bitmap resizeImage(Bitmap bitmap, int requestWidth) {
        int legalWidth = (requestWidth + 7) / 8 * 8;
        int height = (int)((float)(legalWidth * bitmap.getHeight()) / (float)bitmap.getWidth());
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)legalWidth, (int)height, (boolean)true);
    }

    public static Bitmap scaleCanvas(Bitmap bitmap, Rect rect) {
        Bitmap newBitmap = Bitmap.createBitmap((int)rect.width(), (int)rect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(newBitmap);
        Paint paint = new Paint();
        Bitmap temp = bitmap;
        PaintFlagsDrawFilter pfd = new PaintFlagsDrawFilter(0, 3);
        paint.setFilterBitmap(true);
        paint.setAntiAlias(true);
        canvas.setDrawFilter((DrawFilter)pfd);
        canvas.drawBitmap(temp, null, rect, paint);
        return newBitmap;
    }

    public static Bitmap scaleMatrix(Bitmap bitmap, int width) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        float scaleW = width / w;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleW, scaleW);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
    }

    public static byte[] convertToNvlogo(Bitmap bitmap, int requestWidth) {
        int width;
        if (bitmap == null) {
            Log.e((String)"convertToNvlogo: ", (String)"bitmap == null");
            return new byte[0];
        }
        Rect rect = new Rect(0, 0, requestWidth, bitmap.getHeight() * requestWidth / bitmap.getWidth());
        bitmap = BitmapToByteData.scaleCanvas(bitmap, rect);
        int ImgHeight = bitmap.getHeight();
        int ImgWidth = bitmap.getWidth();
        int legalWidth = (ImgWidth + 7) / 8 * 8;
        int legalheight = (int)((float)(legalWidth * ImgHeight) / (float)ImgHeight);
        int height = ImgHeight;
        int X = width = legalWidth;
        int Y = height;
        int m = 0;
        int bytelen = height * width / 8 + 40;
        byte[] cmd = new byte[bytelen];
        cmd[m++] = 29;
        cmd[m++] = 40;
        cmd[m++] = 76;
        cmd[m++] = -109;
        cmd[m++] = 2;
        cmd[m++] = 48;
        cmd[m++] = 67;
        cmd[m++] = 48;
        cmd[m++] = 48;
        cmd[m++] = 48;
        cmd[m++] = 1;
        cmd[m++] = (byte)(X % 256);
        cmd[m++] = (byte)(X / 256);
        cmd[m++] = (byte)(Y % 256);
        cmd[m++] = (byte)(Y / 256);
        cmd[m++] = 49;
        int index = m;
        int temp = 0;
        int[] part = new int[8];
        for (int j = 0; j < ImgHeight; ++j) {
            for (int i = 0; i < legalWidth; i += 8) {
                if (i < ImgWidth) {
                    for (int k = 0; k < 8; ++k) {
                        int blue;
                        int green;
                        if (i + k >= bitmap.getWidth()) continue;
                        int pixel = bitmap.getPixel(i + k, j);
                        int red = (pixel & 0xFF0000) >> 16;
                        int grayPixle = (int)((float)red * 0.3f + (float)(green = (pixel & 0xFF00) >> 8) * 0.59f + (float)(blue = pixel & 0xFF) * 0.11f);
                        part[k] = grayPixle > 200 ? 0 : 1;
                    }
                    temp = part[0] * 128 + part[1] * 64 + part[2] * 32 + part[3] * 16 + part[4] * 8 + part[5] * 4 + part[6] * 2 + part[7] * 1;
                    cmd[index++] = (byte)temp;
                    continue;
                }
                cmd[index++] = 0;
            }
        }
        Log.e((String)"convertToNvlogo: ", (String)"");
        return cmd;
    }

    public static enum BmpType {
        Dithering,
        Threshold;

    }

    public static enum AlignType {
        Left,
        Center,
        Right;

    }
}

