/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import java.io.UnsupportedEncodingException;
import net.posprinter.utils.BitmapToByteData;

public class LabelBitmap {
    public static byte[] bitmap(int x, int y, int mode, Bitmap bitmap, BitmapToByteData.BmpType bmpType) {
        int width = (bitmap.getWidth() + 7) / 8;
        int heigth = bitmap.getHeight();
        String str = "BITMAP " + x + "," + y + "," + width + "," + heigth + "," + mode + ",";
        String end = "\n";
        byte[] ended = LabelBitmap.strTobytes(end, "utf-8");
        byte[] head = LabelBitmap.strTobytes(str, "utf-8");
        byte[] data = LabelBitmap.downLoadBmpToSendTSCData(bitmap, bmpType);
        data = LabelBitmap.byteMerger(head, data);
        data = LabelBitmap.byteMerger(data, ended);
        return data;
    }

    public static Bitmap convertGreyImgByFloyd(Bitmap img) {
        int g;
        int j;
        int i;
        int e;
        int width = img.getWidth();
        int height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        for (e = 0; e < height; ++e) {
            for (i = 0; i < width; ++i) {
                j = pixels[width * e + i];
                gray[width * e + i] = g = (j & 0xFF0000) >> 16;
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                g = gray[width * i + j];
                if (g >= 128) {
                    pixels[width * i + j] = -1;
                    e = g - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    e = g - 0;
                }
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    gray[n] = gray[n] + 3 * e / 8;
                    int n2 = width * (i + 1) + j;
                    gray[n2] = gray[n2] + 3 * e / 8;
                    int n3 = width * (i + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 4;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    gray[n] = gray[n] + 3 * e / 8;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                gray[n] = gray[n] + e / 4;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    public static byte[] downLoadBmpToSendTSCData(Bitmap mBitmap, BitmapToByteData.BmpType bmpType) {
        Bitmap bitmap = LabelBitmap.convertGreyImgByFloyd(mBitmap);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] data = LabelBitmap.getbmpdataTsc(pixels, width, height);
        return data;
    }

    private static byte[] getbmpdataTsc(int[] b, int w, int h) {
        int n = (w + 7) / 8;
        byte[] data = new byte[n * h];
        int mask = 1;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < n * 8; ++x) {
                if (x < w) {
                    if ((b[y * w + x] & 0xFF0000) >> 16 == 0) continue;
                    int n2 = y * n + x / 8;
                    data[n2] = (byte)(data[n2] | (byte)(mask << 7 - x % 8));
                    continue;
                }
                if (x < w) continue;
                int n3 = y * n + x / 8;
                data[n3] = (byte)(data[n3] | (byte)(mask << 7 - x % 8));
            }
        }
        return data;
    }

    public static byte[] sendpicture(int x_coordinates, int y_coordinates, int mode1, Bitmap bitmap) {
        int y;
        Bitmap original_bitmap = null;
        Bitmap gray_bitmap = null;
        Bitmap binary_bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPurgeable = true;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        original_bitmap = bitmap;
        gray_bitmap = LabelBitmap.bitmap2Gray(original_bitmap);
        binary_bitmap = LabelBitmap.gray2Binary(gray_bitmap);
        String x_axis = Integer.toString(x_coordinates);
        String y_axis = Integer.toString(y_coordinates);
        String picture_wdith = Integer.toString((binary_bitmap.getWidth() + 7) / 8);
        String picture_height = Integer.toString(binary_bitmap.getHeight());
        String mode = Integer.toString(0);
        String command = "BITMAP " + x_axis + "," + y_axis + "," + picture_wdith + "," + picture_height + "," + mode + ",";
        byte[] stream = new byte[(binary_bitmap.getWidth() + 7) / 8 * binary_bitmap.getHeight()];
        int Width_bytes = (binary_bitmap.getWidth() + 7) / 8;
        int Width = binary_bitmap.getWidth();
        int Height = binary_bitmap.getHeight();
        for (y = 0; y < Height * Width_bytes; ++y) {
            stream[y] = -1;
        }
        for (y = 0; y < Height; ++y) {
            for (int x = 0; x < Width; ++x) {
                int colorB;
                int colorG;
                int pixelColor = binary_bitmap.getPixel(x, y);
                int colorR = Color.red((int)pixelColor);
                int total = (colorR + (colorG = Color.green((int)pixelColor)) + (colorB = Color.blue((int)pixelColor))) / 3;
                if (total != 0) continue;
                int n = y * ((Width + 7) / 8) + x / 8;
                stream[n] = (byte)(stream[n] ^ (byte)(128 >> x % 8));
            }
        }
        String end = "\n";
        byte[] ended = LabelBitmap.strTobytes(end, "utf-8");
        byte[] head = LabelBitmap.strTobytes(command, "utf-8");
        byte[] data = stream;
        data = LabelBitmap.byteMerger(head, data);
        data = LabelBitmap.byteMerger(data, ended);
        return data;
    }

    public static Bitmap bitmap2Gray(Bitmap bmSrc) {
        int width = bmSrc.getWidth();
        int height = bmSrc.getHeight();
        Bitmap bmpGray = null;
        bmpGray = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmpGray);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmSrc, 0.0f, 0.0f, paint);
        return bmpGray;
    }

    public static Bitmap gray2Binary(Bitmap graymap) {
        int width = graymap.getWidth();
        int height = graymap.getHeight();
        Bitmap binarymap = null;
        binarymap = graymap.copy(Bitmap.Config.ARGB_8888, true);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int col = binarymap.getPixel(i, j);
                int alpha = col & 0xFF000000;
                int red = (col & 0xFF0000) >> 16;
                int green = (col & 0xFF00) >> 8;
                int blue = col & 0xFF;
                int gray = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                gray = gray <= 200 ? 0 : 255;
                int newColor = alpha | gray << 16 | gray << 8 | gray;
                binarymap.setPixel(i, j, newColor);
            }
        }
        return binarymap;
    }

    public static int grayPixle(int pixel) {
        int red = (pixel & 0xFF0000) >> 16;
        int green = (pixel & 0xFF00) >> 8;
        int blue = pixel & 0xFF;
        return (int)((float)red * 0.3f + (float)green * 0.59f + (float)blue * 0.11f);
    }

    public static byte[] strTobytes(String str, String charset) {
        byte[] b = null;
        byte[] data = null;
        try {
            b = str.getBytes("utf-8");
            data = new String(b, "utf-8").getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public static Bitmap scaleBitmapByNum(Bitmap origin, int w, int h) {
        if (origin == null) {
            return null;
        }
        int width = origin.getWidth();
        int height = origin.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale((float)w / (float)width, (float)h / (float)height);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)origin, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        if (newBM.equals(origin)) {
            return newBM;
        }
        return newBM;
    }
}

