/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.posprinter.asynncTask.PosAsynncTask;
import net.posprinter.posprinterface.BackgroundInit;
import net.posprinter.posprinterface.PrinterBinder;
import net.posprinter.posprinterface.ProcessData;
import net.posprinter.posprinterface.TaskCallback;
import net.posprinter.utils.PosPrinterDev;
import net.posprinter.utils.RoundQueue;

public class PrinterConnectionsService
extends Service {
    private final String TAG = "PrinterConnectService";
    private HashMap<String, Printer> printers = new HashMap();
    private final int PORT = 9100;
    private IBinder myBinder = new printerBinder();

    public IBinder onBind(Intent intent) {
        return this.myBinder;
    }

    public void onCreate() {
        super.onCreate();
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)"PrinterConnectService", (String)"onDestroy");
        for (Printer printer : this.printers.values()) {
            if (printer.printerDev == null) continue;
            printer.printerDev.Close();
        }
        this.printers.clear();
    }

    public Printer getPrinter(String ip) {
        return this.printers.get(ip);
    }

    public void removePrinter(String ip) {
        Log.d((String)"PrinterConnectService", (String)"removePrinter");
        this.printers.remove(ip);
    }

    public class printerBinder
    extends Binder
    implements PrinterBinder {
        @Override
        public void connectBtPort(final String bluetoothID, TaskCallback callback) {
            Printer printer = PrinterConnectionsService.this.getPrinter(bluetoothID);
            if (printer != null) {
                PrinterConnectionsService.this.removePrinter(bluetoothID);
            }
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    boolean flag;
                    Printer printer = new Printer();
                    printer.que = printer.getinstaceRoundQueue();
                    printer.printerDev = new PosPrinterDev(PosPrinterDev.PortType.Bluetooth, bluetoothID);
                    printer.BtPathName = bluetoothID;
                    printer.mMsg = printer.printerDev.Open();
                    printer.type = PosPrinterDev.PortType.Bluetooth.name();
                    if (printer.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        printer.isConnected = true;
                        flag = true;
                    } else {
                        flag = false;
                    }
                    if (flag) {
                        PrinterConnectionsService.this.printers.put(bluetoothID, printer);
                    }
                    return flag;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void connectUsbPort(final Context context, final String usbPathName, TaskCallback callback) {
            Printer printer = PrinterConnectionsService.this.getPrinter(usbPathName);
            if (printer != null) {
                PrinterConnectionsService.this.removePrinter(usbPathName);
            }
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    boolean flag;
                    Printer printer = new Printer();
                    printer.ip = null;
                    printer.usbPathName = usbPathName;
                    printer.que = printer.getinstaceRoundQueue();
                    printer.printerDev = new PosPrinterDev(PosPrinterDev.PortType.USB, context, usbPathName);
                    printer.mMsg = printer.printerDev.Open();
                    printer.type = PosPrinterDev.PortType.USB.name();
                    if (printer.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        printer.isConnected = true;
                        flag = true;
                    } else {
                        printer.isConnected = false;
                        flag = false;
                    }
                    Log.d((String)"PrinterConnectService", (String)("connectUsbPort flag:" + flag));
                    PrinterConnectionsService.this.printers.put(usbPathName, printer);
                    return flag;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void connectNetPort(final String ip, TaskCallback callback) {
            Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer != null) {
                PrinterConnectionsService.this.removePrinter(ip);
            }
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    boolean flag;
                    Printer printer = new Printer();
                    printer.ip = ip;
                    printer.que = printer.getinstaceRoundQueue();
                    printer.printerDev = new PosPrinterDev(PosPrinterDev.PortType.Ethernet, ip, 9100);
                    printer.mMsg = printer.printerDev.Open();
                    printer.type = PosPrinterDev.PortType.Ethernet.name();
                    try {
                        if (printer.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                            printer.isConnected = true;
                            flag = true;
                        } else {
                            flag = false;
                        }
                    }
                    catch (Exception var4) {
                        var4.printStackTrace();
                        flag = false;
                    }
                    if (flag) {
                        PrinterConnectionsService.this.printers.put(ip, printer);
                    }
                    return flag;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void disconnectCurrentPort(String ip, TaskCallback callback) {
            final Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("disconnectCurrentPort ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
                callback.OnFailed();
            } else {
                PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                    @Override
                    public boolean doinbackground() {
                        boolean flag;
                        printer.mMsg = printer.printerDev.Close();
                        if (printer.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ClosePortSuccess)) {
                            printer.isConnected = false;
                            if (printer.que != null) {
                                printer.que.clear();
                            }
                            flag = true;
                        } else {
                            flag = false;
                        }
                        return flag;
                    }
                });
                task.execute(new Void[0]);
            }
        }

        @Override
        public void disconnectAll(TaskCallback callback) {
            int count = PrinterConnectionsService.this.printers.size();
            if (count == 0) {
                Log.d((String)"PrinterConnectService", (String)("disconnectAll count: " + count));
                callback.OnSucceed();
            } else {
                PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                    @Override
                    public boolean doinbackground() {
                        for (Printer printer : PrinterConnectionsService.this.printers.values()) {
                            String ip = printer.ip;
                            printerBinder.this.disconnectCurrentPort(ip, new TaskCallback(){

                                @Override
                                public void OnSucceed() {
                                }

                                @Override
                                public void OnFailed() {
                                }
                            });
                        }
                        return true;
                    }
                });
                task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
            }
        }

        @Override
        public void acceptdatafromprinter(String ip, TaskCallback callback) {
            final Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("acceptdatafromprinter ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
                callback.OnFailed();
            } else {
                new PosAsynncTask(callback, new BackgroundInit(){

                    @Override
                    public boolean doinbackground() {
                        printer.que = printer.getinstaceRoundQueue();
                        byte[] buffer = new byte[4];
                        printer.que.clear();
                        Log.i((String)"TAG", (String)printer.printerDev.Read(buffer).GetErrorCode().toString());
                        printer.que.addLast(buffer);
                        Log.i((String)"TAG", (String)("\u5f00\u59cb\u8bfb\u53d6" + Arrays.toString(printer.que.getLast())));
                        while (printer.printerDev.Read(buffer).GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ReadDataSuccess)) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException var3) {
                                var3.printStackTrace();
                                return false;
                            }
                        }
                        printer.isConnected = false;
                        return false;
                    }
                });
            }
        }

        @Override
        public RoundQueue<byte[]> readBuffer(String ip) {
            Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("readBuffer ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
                return null;
            }
            new RoundQueue(500);
            RoundQueue<byte[]> queue = printer.que;
            return queue;
        }

        @Override
        public void clearBuffer(String ip) {
            Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("clearBuffer ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
            } else {
                printer.que.clear();
            }
        }

        @Override
        public void checkLinkedState(String ip, TaskCallback execute) {
            final Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("checkLinkedState ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
                execute.OnFailed();
            } else {
                PosAsynncTask task = new PosAsynncTask(execute, new BackgroundInit(){

                    @Override
                    public boolean doinbackground() {
                        if (printer.isConnected) {
                            printer.isConnected = printer.printerDev.GetPortInfo().PortIsOpen();
                            return true;
                        }
                        return false;
                    }
                });
                task.execute(new Void[0]);
            }
        }

        @Override
        public void write(String ip, final byte[] data, TaskCallback callback) {
            final Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("write ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
                callback.OnFailed();
            } else {
                PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                    @Override
                    public boolean doinbackground() {
                        if (data != null) {
                            block4: {
                                try {
                                    printer.mMsg = printer.printerDev.Write(data);
                                    if (printer.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                                        printer.isConnected = true;
                                        return true;
                                    }
                                }
                                catch (Exception var2) {
                                    if (var2 == null) break block4;
                                    var2.printStackTrace();
                                }
                            }
                            printer.isConnected = false;
                        }
                        return false;
                    }
                });
                task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
            }
        }

        @Override
        public void writeDataByYouself(String ip, TaskCallback callback, final ProcessData processData) {
            final Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("writeDataByYouself ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
                callback.OnFailed();
            } else {
                PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                    @Override
                    public boolean doinbackground() {
                        List<byte[]> list = processData.processDataBeforeSend();
                        if (list == null) {
                            return false;
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            printer.mMsg = printer.printerDev.Write(list.get(i));
                        }
                        if (printer.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                            printer.isConnected = true;
                            return true;
                        }
                        return false;
                    }
                });
                task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
            }
        }

        @Override
        public boolean isConnect(String ip) {
            Printer printer = PrinterConnectionsService.this.getPrinter(ip);
            if (printer == null) {
                Log.d((String)"PrinterConnectService", (String)("isConnect ip: " + ip + ", \u6253\u5370\u673a\u672a\u6dfb\u52a0"));
                return false;
            }
            try {
                printer.isConnected = printer.printerDev.GetPortInfo().PortIsOpen();
            }
            catch (Throwable var4) {
                var4.printStackTrace();
            }
            return printer.isConnected;
        }
    }

    public class Printer {
        public PosPrinterDev printerDev;
        public PosPrinterDev.ReturnMessage mMsg;
        public boolean isConnected = false;
        public RoundQueue<byte[]> que;
        public String ip;
        public String type;
        public String usbPathName;
        public String BtPathName;

        private RoundQueue<byte[]> getinstaceRoundQueue() {
            if (this.que == null) {
                this.que = new RoundQueue(500);
            }
            return this.que;
        }
    }
}

