/*
 * Decompiled with CFR 0.152.
 */
package net.posprinter.service;

import android.app.PendingIntent;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.posprinter.asynncTask.PosAsynncTask;
import net.posprinter.posprinterface.BackgroundInit;
import net.posprinter.posprinterface.IMyBinder;
import net.posprinter.posprinterface.ProcessData;
import net.posprinter.posprinterface.TaskCallback;
import net.posprinter.utils.PosPrinterDev;
import net.posprinter.utils.RoundQueue;

public class PosprinterService
extends Service {
    private PosPrinterDev printerDev;
    private ArrayList<PosPrinterDev> PrinterDevList = new ArrayList();
    private PosPrinterDev.ReturnMessage mMsg;
    private boolean isConnected = false;
    private RoundQueue<byte[]> que;
    private IBinder myBinder = new MyBinder();
    private final String TAG = "PosprinterService";
    private boolean printerIsNormal = true;

    private RoundQueue<byte[]> getinstaceRoundQueue() {
        if (this.que == null) {
            this.que = new RoundQueue(500);
        }
        return this.que;
    }

    public void onCreate() {
        super.onCreate();
        this.que = this.getinstaceRoundQueue();
        Log.i((String)"PosprinterService", (String)"onCreate");
    }

    public IBinder onBind(Intent intent) {
        Log.i((String)"PosprinterService", (String)"onBind");
        return this.myBinder;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.printerDev != null) {
            this.printerDev.Close();
        }
    }

    public class MyBinder
    extends Binder
    implements IMyBinder {
        private String USBName;
        private Context Context;
        private PosPrinterDev dev;
        private PosPrinterDev.PortType portTp;
        private List<String> mFound;
        private List<String> mBound;
        private BluetoothAdapter mbBluetoothAdapter;
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.bluetooth.device.action.FOUND")) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    MyBinder.this.mFound.add(device.getName() + '\n' + device.getAddress());
                }
            }
        };
        UsbManager mUsbManager;
        private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
        private final BroadcastReceiver mUsbPermissionActionReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (MyBinder.ACTION_USB_PERMISSION.equals(action)) {
                    5 var4_4 = this;
                    synchronized (var4_4) {
                        UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
                        if (intent.getBooleanExtra("permission", false)) {
                            if (null != usbDevice) {
                                MyBinder.this.afterGetUsbPermission(usbDevice);
                            }
                        } else {
                            Toast.makeText((Context)context, (CharSequence)String.valueOf("Permission denied for device" + usbDevice), (int)1).show();
                        }
                    }
                }
            }
        };

        @Override
        public void ConnectNetPort(final String ethernetIP, final int ethernetPort, TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.printerDev = new PosPrinterDev(PosPrinterDev.PortType.Ethernet, ethernetIP, ethernetPort);
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Open();
                    MyBinder.this.portTp = PosPrinterDev.PortType.Ethernet;
                    try {
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                            PosprinterService.this.isConnected = true;
                            Log.e((String)"connectNetPort", (String)"connect ok");
                            PosprinterService.this.PrinterDevList.add(PosprinterService.this.printerDev);
                            return true;
                        }
                        Log.e((String)"connectNetPort", (String)"conect fail");
                        PosprinterService.this.isConnected = false;
                        return false;
                    }
                    catch (Exception var2) {
                        var2.printStackTrace();
                        Log.e((String)"connectNetPort", (String)"connect fail");
                        return false;
                    }
                }
            });
            Log.e((String)"connectNetPort", (String)"connect ok");
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void ConnectBtPort(final String bluetoothID, TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.printerDev = new PosPrinterDev(PosPrinterDev.PortType.Bluetooth, bluetoothID);
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Open();
                    MyBinder.this.portTp = PosPrinterDev.PortType.Bluetooth;
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void ConnectUsbPort(final Context context, final String usbPathName, TaskCallback callback) {
            this.USBName = usbPathName;
            this.Context = context;
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.printerDev = new PosPrinterDev(PosPrinterDev.PortType.USB, context, usbPathName);
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Open();
                    MyBinder.this.portTp = PosPrinterDev.PortType.USB;
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.OpenPortSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        private void openUsbDevice() {
            this.tryGetUsbPermission();
        }

        private void tryGetUsbPermission() {
            this.mUsbManager = (UsbManager)PosprinterService.this.getSystemService("usb");
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            PosprinterService.this.registerReceiver(this.mUsbPermissionActionReceiver, filter);
            PendingIntent mPermissionIntent = PendingIntent.getBroadcast((Context)PosprinterService.this.getApplicationContext(), (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            for (UsbDevice usbDevice : this.mUsbManager.getDeviceList().values()) {
                if (this.mUsbManager.hasPermission(usbDevice)) continue;
                this.mUsbManager.requestPermission(usbDevice, mPermissionIntent);
            }
        }

        private void afterGetUsbPermission(UsbDevice usbDevice) {
            this.doYourOpenUsbDevice(usbDevice);
        }

        private void doYourOpenUsbDevice(UsbDevice usbDevice) {
            UsbDeviceConnection connection = this.mUsbManager.openDevice(usbDevice);
        }

        @Override
        public void DisconnectCurrentPort(TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Close();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ClosePortSuccess)) {
                        PosprinterService.this.isConnected = false;
                        if (PosprinterService.this.que != null) {
                            PosprinterService.this.que.clear();
                        }
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void Write(final byte[] data, TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    if (data != null) {
                        PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(data);
                        PosprinterService.this.que = PosprinterService.this.getinstaceRoundQueue();
                        PosprinterService.this.que.clear();
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                            PosprinterService.this.isConnected = true;
                            return true;
                        }
                        PosprinterService.this.isConnected = false;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void WriteSendData(TaskCallback callback, final ProcessData processData) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list == null) {
                        return false;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(list.get(i));
                    }
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) {
                        PosprinterService.this.isConnected = true;
                        return !((PosprinterService)PosprinterService.this).printerDev.status.error;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void WriteDataByUSB(TaskCallback callback, final ProcessData processData, final int timeout) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list == null) {
                        return false;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(list.get(i), true, timeout);
                        int timeLeft = timeout;
                        int temp = timeout;
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.InTimeout)) {
                            temp = Integer.parseInt(PosprinterService.this.mMsg.GetErrorStrings());
                            for (int j = 0; j < list.size(); ++j) {
                                timeLeft = temp * (list.size() - j) / list.size();
                                PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(list.get(j), false, timeLeft);
                            }
                            return PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess);
                        }
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) continue;
                        return false;
                    }
                    return PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess);
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void WriteDataByUsbNoReprint(TaskCallback callback, final ProcessData processData, final int timeout) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list == null) {
                        return false;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(list.get(i), true, timeout);
                        int timeLeft = timeout;
                        int temp = timeout;
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.InTimeout)) {
                            return false;
                        }
                        if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) continue;
                        return false;
                    }
                    return PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess);
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void WriteDataByUSB(TaskCallback callback, final ProcessData processData) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list != null) {
                        try {
                            for (int i = 0; i < list.size(); ++i) {
                                PosprinterService.this.mMsg = PosprinterService.this.printerDev.Write(list.get(i), true);
                                if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.WriteDataSuccess)) continue;
                                return false;
                            }
                            return true;
                        }
                        catch (NullPointerException var3) {
                            var3.printStackTrace();
                            return false;
                        }
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void Acceptdatafromprinter(TaskCallback callback, int cout) {
            final byte[] buffer = new byte[cout];
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.que = PosprinterService.this.getinstaceRoundQueue();
                    PosprinterService.this.que.clear();
                    PosprinterService.this.printerDev.Read(buffer);
                    PosprinterService.this.que.addLast(buffer);
                    return true;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void PrinterIsNormal(TaskCallback callback) {
            final byte[] buffer = new byte[4];
            final byte[] normal = new byte[]{22, 0, 0, 0};
            final byte[] command = new byte[]{16, 4, 1};
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.printerDev.Write(command);
                    PosprinterService.this.printerDev.Read(buffer);
                    return Arrays.equals(buffer, normal);
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public RoundQueue<byte[]> ReadBuffer() {
            new RoundQueue(500);
            RoundQueue queue = PosprinterService.this.que;
            return queue;
        }

        @Override
        public void ClearBuffer() {
            PosprinterService.this.que.clear();
        }

        @Override
        public void CheckLinkedState(TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    return PosprinterService.this.printerDev != null ? PosprinterService.this.printerDev.GetPortInfo().PortIsOpen() : false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public void DisconnetNetPort(TaskCallback callback) {
            PosAsynncTask task = new PosAsynncTask(callback, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    PosprinterService.this.mMsg = PosprinterService.this.printerDev.Close();
                    if (PosprinterService.this.mMsg.GetErrorCode().equals((Object)PosPrinterDev.ErrorCode.ClosePortSuccess)) {
                        PosprinterService.this.isConnected = false;
                        return true;
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        @Override
        public List<String> OnDiscovery(PosPrinterDev.PortType portType, Context context) {
            this.mBound = new ArrayList<String>();
            this.mFound = new ArrayList<String>();
            if (portType == PosPrinterDev.PortType.Bluetooth) {
                this.mbBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (this.mbBluetoothAdapter == null) {
                    Toast.makeText((Context)context, (CharSequence)"device didn't suport bluetooth!", (int)0).show();
                    return null;
                }
                if (this.mbBluetoothAdapter.isEnabled()) {
                    if (this.mbBluetoothAdapter.enable()) {
                        if (!this.mbBluetoothAdapter.isDiscovering()) {
                            this.mbBluetoothAdapter.startDiscovery();
                        }
                        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
                        PosprinterService.this.registerReceiver(this.mReceiver, filter);
                        Set pairedDevice = this.mbBluetoothAdapter.getBondedDevices();
                        if (pairedDevice.size() > 0) {
                            for (BluetoothDevice device : pairedDevice) {
                                this.mBound.add(device.getName() + "\n" + device.getAddress());
                            }
                        } else {
                            Toast.makeText((Context)context, (CharSequence)"no paired device !", (int)0).show();
                        }
                    } else {
                        Toast.makeText((Context)context, (CharSequence)"enabel bluetooth fail1,", (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)context, (CharSequence)"enabel bluetooth fail2,", (int)0).show();
                }
                if (this.mBound != null && this.mFound != null) {
                    this.mBound.addAll(this.mFound);
                }
            } else if (portType == PosPrinterDev.PortType.USB) {
                this.mBound = PosPrinterDev.GetUsbPathNames(context);
            }
            return this.mBound;
        }

        @Override
        public List<String> getBtAvailableDevice() {
            this.mbBluetoothAdapter.cancelDiscovery();
            return this.mFound;
        }

        @Override
        public PosPrinterDev.PrinterStatus GetPrinterStatus() {
            return ((PosprinterService)PosprinterService.this).printerDev.status;
        }

        @Override
        public void StopMonitorPrinter() {
            PosprinterService.this.printerDev.StopMonitor();
        }
    }
}

